import Mapper

# TAGS INDICATE IDENTIAL SHEETS
# NUMBERS are completely unconstrained
# LETTERS enforce internal symmetry
# < indicates a tile, with the arrow pointed in direction of polarization and feed
# X indicates an empty gap
# || or = (double lines) imply mirror symmetry on either side

#  |--------------------------------------------|
#  |  < |  1 |  < |  1 |  < |  1 |  < |  1 |  < |
#  |--------------------------------------------|
#  |  1 |  X |  1 |  X |  1 |  X |  1 |  X |  1 |
#  |--------------------------------------------|
#  |  < |  1 |  < |  1 |  < |  1 |  < |  1 |  < |
#  |--------------------------------------------|
#  |  1 |  X |  1 |  X |  1 |  X |  1 |  X |  1 |
#  |--------------------------------------------|
#  |  < |  1 |  < |  1 |  < |  1 |  < |  1 |  < |
#  |--------------------------------------------|
#  |  1 |  X |  1 |  X |  1 |  X |  1 |  X |  1 |
#  |--------------------------------------------|
#  |  < |  1 |  < |  1 |  < |  1 |  < |  1 |  < |
#  |--------------------------------------------|
#  |  1 |  X |  1 |  X |  1 |  X |  1 |  X |  1 |
#  |--------------------------------------------|
#  |  < |  1 |  < |  1 |  < |  1 |  < |  1 |  < |
#  |--------------------------------------------|

#           Idendical Sheets
#              TOTAL NUMBER OF BITS = 24

# maps the switch states of every sheet to be identical
# better to just program with broadcast, but this should be identical if
# used to program individual sheets
class IdenticalMapper(Mapper.Mapper):
    # intializes the mapper
    # index map is a dictionary
    # return type: self
    def __init__(self):
        indexMap = {}
        for sheet_x in range(-5,5):
            for sheet_y in range(-5,5):
                num_sheet_steps = (sheet_x+sheet_y)%2
                if num_sheet_steps != 0:
                    for switch_x in range(-3,4):
                        for switch_y in range(-3,4):
                            num_switch_steps = (switch_x+switch_y)%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                # check switch direction
                                if (switch_y%2) == 0: # y switch
                                    y_col = (switch_x + 3)/2
                                    y_row = (2-switch_y)/2
                                    bit_loc = 11 - (y_col + 4*y_row)
                                else: # x switch
                                    x_col = (switch_x+2)/2
                                    x_row = (3-switch_y)/2
                                    bit_loc = 23 - (x_col + 3*x_row)
                                indexMap[coordinates] = bit_loc
        super(IdenticalMapper,self).__init__(24,indexMap)
